#ifndef __C_MSGBUFFER_H
#define __C_MSGBUFFER_H

#include "Interfaces/cObject.h"

class cBufferManager;
/*
 * cMsgBuffer.h
 *
 * Message Buffer.
 */
class cMsgBuffer : public cObject
{

  public:
	cMsgBuffer();
	void AddRef(void);
	void Release(void);
	
	bool Init(unsigned int totalSize, unsigned int headerReserve);
	bool Init(unsigned int totalSize);

	bool AddHeader(void *headerBuf, unsigned int headerSize);
	bool RemoveHeader(int size)	{ mData = (char *)mData + size; return true; }

	bool SetPayload(void *buffer, int size);	// Changes size of paylaod as well.
	bool GetPayload(void **buffer, int* size);
	unsigned int GetPayloadSize();
	bool SetPayloadSize(unsigned int size)
	{
		unsigned int headerReserve = _HeaderReserveSize();
		if( size > (mBufferSize - headerReserve) )
		{
			return false;
		}
		// New size is req + size of reserved header space.
		mBufferSize = headerReserve + size;
		return true;
	}

	cMsgBuffer* Clone();	// Creates a new copy of this message buffer.

  private:
	
    unsigned int _HeaderReserveSize() { return ((char *)mData-(char *)mBuffer); }

	void*			mData;
	void*			mBuffer;
	unsigned int	mBufferSize;
	int				mRefCount;
};

#endif
